<?php

use yii\helpers\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<?php
NavBar::begin([
    'brandLabel' => 'Отдел кадров',
    'brandUrl' => Yii::$app->homeUrl,
    'options' => [
        'class' => 'navbar navbar-expand-lg navbar-dark bg-dark fixed-top',
    ],
]);



// Если пользователь не вошёл — показываем ссылки на регистрацию и вход
if (Yii::$app->user->isGuest) {
    $menuItems[] = ['label' => 'Вход', 'url' => ['/site/login']];
    $menuItems[] = ['label' => 'Регистрация', 'url' => ['/site/register']];
} else {
    // Если вошёл — показываем личный кабинет и выход
    $menuItems[] = ['label' => 'Анкета', 'url' => ['/profile/form']];
    $menuItems[] = ['label' => 'Личный кабинет', 'url' => ['/profile/cabinet']];

    // Если это администратор — добавим ссылку на панель
    if (Yii::$app->user->identity->email === 'admin@mail.ru') {
        $menuItems[] = ['label' => 'Админ-панель', 'url' => ['/admin/index']];
    }

    $menuItems[] = '<li>'
        . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-flex'])
        . Html::submitButton(
            'Выход (' . Yii::$app->user->identity->fio . ')',
            ['class' => 'btn btn-link logout text-white']
        )
        . Html::endForm()
        . '</li>';
}

echo Nav::widget([
    'options' => ['class' => 'navbar-nav ms-auto'],
    'items' => $menuItems,
]);

NavBar::end();
?>

<div class="container" style="margin-top: 80px;">
    <?= Breadcrumbs::widget([
        'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
    ]) ?>
    <?= $content ?>
</div>



<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
