<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Авторизация';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-start: #6366f1;
            --primary-mid: #8b5cf6;
            --primary-end: #ec4899;
            --secondary-start: #06b6d4;
            --secondary-end: #3b82f6;
            --accent-start: #f59e0b;
            --accent-end: #ef4444;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --border: #334155;
            --shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(-45deg, #1e1b4b, #312e81, #3730a3, #4f46e5);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
            color: var(--light);
        }

        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        /* Анимированные геометрические фигуры */
        .shapes-container {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            pointer-events: none;
        }

        .shape {
            position: absolute;
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end));
            opacity: 0.1;
            filter: blur(20px);
            animation: shapeFloat 20s infinite ease-in-out;
        }

        .shape:nth-child(1) {
            width: 300px;
            height: 300px;
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            top: 10%;
            left: 5%;
            animation-delay: 0s;
            background: linear-gradient(45deg, var(--primary-start), var(--secondary-start));
        }

        .shape:nth-child(2) {
            width: 200px;
            height: 200px;
            border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            top: 70%;
            right: 10%;
            animation-delay: 5s;
            background: linear-gradient(45deg, var(--primary-end), var(--accent-start));
        }

        .shape:nth-child(3) {
            width: 150px;
            height: 150px;
            border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            bottom: 20%;
            left: 15%;
            animation-delay: 10s;
            background: linear-gradient(45deg, var(--secondary-end), var(--primary-mid));
        }

        @keyframes shapeFloat {
            0%, 100% { 
                transform: translate(0, 0) rotate(0deg) scale(1);
                border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            }
            33% { 
                transform: translate(50px, -30px) rotate(120deg) scale(1.1);
                border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            }
            66% { 
                transform: translate(-30px, 40px) rotate(240deg) scale(0.9);
                border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            }
        }

        /* Контейнер авторизации */
        .login-container {
            max-width: 480px;
            width: 100%;
            animation: slideInUp 0.8s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(60px) scale(0.95);
                filter: blur(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
                filter: blur(0);
            }
        }

        .login-card {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 28px;
            overflow: hidden;
            box-shadow: var(--shadow);
            position: relative;
            border: 1px solid rgba(99, 102, 241, 0.3);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .login-card:hover {
            transform: translateY(-8px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        /* Анимированный верхний бордер */
        .login-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, 
                var(--primary-start),
                var(--primary-mid),
                var(--primary-end),
                var(--secondary-start)
            );
            background-size: 300% 100%;
            animation: shimmerBorder 3s linear infinite;
            z-index: 2;
        }

        @keyframes shimmerBorder {
            0% { background-position: -300% 0; }
            100% { background-position: 300% 0; }
        }

        .login-header {
            padding: 50px 40px 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .login-header::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(
                circle at 50% 0%,
                rgba(99, 102, 241, 0.2) 0%,
                transparent 70%
            );
            animation: pulseGlow 4s ease-in-out infinite alternate;
        }

        @keyframes pulseGlow {
            0% { opacity: 0.3; transform: scale(1); }
            100% { opacity: 0.6; transform: scale(1.1); }
        }

        .logo-container {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-start), var(--primary-end));
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 2.2rem;
            position: relative;
            z-index: 2;
            box-shadow: 
                0 10px 30px rgba(99, 102, 241, 0.4),
                0 0 50px rgba(99, 102, 241, 0.2),
                inset 0 0 20px rgba(255, 255, 255, 0.1);
            animation: 
                logoRotate 8s linear infinite,
                logoFloat 3s ease-in-out infinite;
            transform-style: preserve-3d;
        }

        @keyframes logoRotate {
            0% { transform: rotateY(0deg) rotateX(0deg); }
            25% { transform: rotateY(90deg) rotateX(10deg); }
            50% { transform: rotateY(180deg) rotateX(0deg); }
            75% { transform: rotateY(270deg) rotateX(-10deg); }
            100% { transform: rotateY(360deg) rotateX(0deg); }
        }

        @keyframes logoFloat {
            0%, 100% { transform: translateY(0) rotateY(0); }
            50% { transform: translateY(-15px) rotateY(180deg); }
        }

        .logo-container i {
            color: white;
            text-shadow: 0 0 20px rgba(255, 255, 255, 0.5);
        }

        .login-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 10px;
            position: relative;
            z-index: 2;
            background: linear-gradient(45deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: 0 0 30px rgba(99, 102, 241, 0.3);
            animation: textShimmer 4s ease-in-out infinite;
        }

        @keyframes textShimmer {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        .login-header p {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 400;
            position: relative;
            z-index: 2;
            color: #cbd5e1;
        }

        .login-body {
            padding: 40px;
            position: relative;
            z-index: 2;
        }

        .form-group {
            margin-bottom: 30px;
            animation: fadeInUp 0.6s ease-out both;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .form-group:nth-child(1) { animation-delay: 0.1s; }
        .form-group:nth-child(2) { animation-delay: 0.2s; }
        .form-group:nth-child(3) { animation-delay: 0.3s; }
        .form-group:nth-child(4) { animation-delay: 0.4s; }

        .form-label {
            display: flex;
            align-items: center;
            gap: 12px;
            color: var(--light);
            font-weight: 600;
            margin-bottom: 15px;
            font-size: 1rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }

        .form-label i {
            color: var(--primary-start);
            font-size: 1.1rem;
            transition: all 0.3s ease;
            text-shadow: 0 0 15px rgba(99, 102, 241, 0.5);
            animation: iconPulse 2s infinite;
        }

        @keyframes iconPulse {
            0%, 100% { 
                transform: scale(1);
                text-shadow: 0 0 15px rgba(99, 102, 241, 0.5);
            }
            50% { 
                transform: scale(1.1);
                text-shadow: 0 0 25px rgba(99, 102, 241, 0.8);
            }
        }

        .form-label:hover {
            color: var(--primary-start);
            transform: translateX(5px);
        }

        .input-group {
            position: relative;
            transition: all 0.3s ease;
        }

        .input-group:hover {
            transform: translateY(-2px);
        }

        .form-control {
            width: 100%;
            padding: 18px 20px 18px 55px;
            border: 2px solid rgba(51, 65, 85, 0.3);
            border-radius: 16px;
            font-size: 1rem;
            font-weight: 500;
            color: var(--light);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-start);
            box-shadow: 
                0 0 0 4px rgba(99, 102, 241, 0.1),
                0 0 25px rgba(99, 102, 241, 0.3);
            background: rgba(30, 41, 59, 0.8);
            transform: scale(1.02);
        }

        .form-control::placeholder {
            color: rgba(203, 213, 225, 0.5);
        }

        .input-icon {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-start);
            font-size: 1.2rem;
            transition: all 0.3s ease;
            z-index: 2;
        }

        .form-control:focus + .input-icon {
            color: var(--primary-end);
            transform: translateY(-50%) scale(1.1);
            text-shadow: 0 0 20px rgba(99, 102, 241, 0.8);
        }

        .password-toggle {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: rgba(203, 213, 225, 0.5);
            cursor: pointer;
            padding: 8px;
            border-radius: 8px;
            transition: all 0.3s ease;
            z-index: 2;
        }

        .password-toggle:hover {
            color: var(--primary-start);
            background: rgba(99, 102, 241, 0.1);
            transform: translateY(-50%) scale(1.1);
        }

        .btn-login {
            width: 100%;
            padding: 20px;
            background: linear-gradient(135deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            background-size: 200% 200%;
            color: white;
            border: none;
            border-radius: 16px;
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            box-shadow: 
                0 10px 30px rgba(99, 102, 241, 0.4),
                0 0 30px rgba(99, 102, 241, 0.2);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
            animation: gradientFlow 3s ease infinite;
        }

        @keyframes gradientFlow {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(255, 255, 255, 0.2), 
                transparent);
            transition: left 0.6s;
        }

        .btn-login:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 
                0 15px 40px rgba(99, 102, 241, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
        }

        .btn-login:hover::before {
            left: 100%;
        }

        .btn-login:active {
            transform: translateY(-1px);
        }

        .login-footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px solid rgba(51, 65, 85, 0.3);
            animation: fadeIn 1s ease 0.6s both;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .register-link {
            color: #94a3b8;
            font-size: 1rem;
        }

        .register-link a {
            color: var(--primary-start);
            text-decoration: none;
            font-weight: 600;
            margin-left: 8px;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            border-radius: 12px;
            background: rgba(99, 102, 241, 0.1);
            border: 1px solid rgba(99, 102, 241, 0.2);
        }

        .register-link a:hover {
            color: white;
            background: rgba(99, 102, 241, 0.2);
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(99, 102, 241, 0.3);
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 25px;
            animation: fadeInUp 0.6s ease-out 0.3s both;
            padding: 15px 20px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            transition: all 0.3s ease;
        }

        .checkbox-group:hover {
            background: rgba(255, 255, 255, 0.08);
            transform: translateY(-2px);
        }

        .checkbox-group input[type="checkbox"] {
            width: 22px;
            height: 22px;
            border-radius: 6px;
            border: 2px solid rgba(99, 102, 241, 0.5);
            appearance: none;
            cursor: pointer;
            position: relative;
            transition: all 0.3s ease;
            background: rgba(30, 41, 59, 0.7);
        }

        .checkbox-group input[type="checkbox"]:checked {
            background: linear-gradient(135deg, var(--primary-start), var(--secondary-start));
            border-color: transparent;
            box-shadow: 0 0 20px rgba(99, 102, 241, 0.5);
        }

        .checkbox-group input[type="checkbox"]:checked::after {
            content: '✓';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 12px;
            font-weight: bold;
        }

        .checkbox-group label {
            color: #cbd5e1;
            font-size: 1rem;
            cursor: pointer;
            transition: color 0.3s ease;
        }

        .checkbox-group:hover label {
            color: var(--light);
        }

        .forgot-password {
            color: var(--primary-start);
            text-decoration: none;
            font-size: 0.95rem;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-block;
            margin-top: 12px;
            position: relative;
        }

        .forgot-password::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 1px;
            background: linear-gradient(90deg, var(--primary-start), transparent);
            transition: width 0.3s ease;
        }

        .forgot-password:hover {
            color: var(--primary-end);
            text-shadow: 0 0 15px rgba(236, 72, 153, 0.5);
        }

        .forgot-password:hover::before {
            width: 100%;
        }

        .error-message {
            color: #ef4444;
            font-size: 0.9rem;
            margin-top: 8px;
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 15px;
            background: rgba(239, 68, 68, 0.1);
            border-radius: 10px;
            border-left: 3px solid #ef4444;
            animation: shakeError 0.5s ease;
        }

        @keyframes shakeError {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }

        /* Анимированные частицы */
        .particles {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: -1;
        }

        .particle {
            position: absolute;
            background: var(--primary-start);
            border-radius: 50%;
            animation: particleFloat 20s infinite linear;
            opacity: 0.1;
            filter: blur(1px);
        }

        @keyframes particleFloat {
            0% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 0.1;
            }
            90% {
                opacity: 0.1;
            }
            100% {
                transform: translateY(-100px) rotate(720deg);
                opacity: 0;
            }
        }

        @media (max-width: 768px) {
            .login-container {
                max-width: 100%;
            }

            .login-header {
                padding: 40px 25px 30px;
            }

            .login-body {
                padding: 30px 25px;
            }

            .login-header h1 {
                font-size: 2rem;
            }

            .logo-container {
                width: 70px;
                height: 70px;
                font-size: 2rem;
            }

            .btn-login {
                padding: 18px;
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
<div class="shapes-container">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
</div>

<div class="particles" id="particles"></div>

<div class="login-container">
    <div class="login-card">
        <div class="login-header">
            <div class="logo-container">
                <i class="fas fa-lock"></i>
            </div>
            <h1><?= Html::encode($this->title) ?></h1>
            <p>Войдите в ваш аккаунт</p>
        </div>

        <div class="login-body">
            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'options' => ['class' => 'login-form'],
                'fieldConfig' => [
                    'template' => "{label}\n<div class='input-group'>{input}<span class='input-icon'>{icon}</span></div>\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'error-message']
                ]
            ]); ?>

            <div class="form-group">
                <?= $form->field($model, 'email', [
                    'parts' => ['{icon}' => '<i class="fas fa-envelope"></i>']
                ])->textInput([
                    'placeholder' => 'your@email.com',
                    'id' => 'email-field'
                ])->label('<i class="fas fa-envelope"></i> Email') ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'password', [
                    'parts' => ['{icon}' => '<i class="fas fa-lock"></i>']
                ])->passwordInput([
                    'placeholder' => 'Введите ваш пароль',
                    'id' => 'password-field'
                ])->label('<i class="fas fa-lock"></i> Пароль') ?>
                <button type="button" class="password-toggle" id="password-toggle">
                    <i class="fas fa-eye"></i>
                </button>
                <a href="#" class="forgot-password">Забыли пароль?</a>
            </div>

            <div class="checkbox-group">
                <?= Html::checkbox('rememberMe', false, ['id' => 'remember-me']) ?>
                <label for="remember-me">Запомнить меня</label>
            </div>

            <div class="form-group">
                <?= Html::submitButton('<i class="fas fa-sign-in-alt"></i> Войти', [
                    'class' => 'btn-login',
                    'id' => 'login-button'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>

            <div class="login-footer">
                <div class="register-link">
                    Нет аккаунта? 
                    <a href="<?= \yii\helpers\Url::to(['/site/signup']) ?>">
                        <i class="fas fa-user-plus"></i> Зарегистрироваться
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Создание частиц
    function createParticles() {
        const container = document.getElementById('particles');
        if (!container) return;
        
        container.innerHTML = '';
        
        for (let i = 0; i < 30; i++) {
            const particle = document.createElement('div');
            particle.classList.add('particle');
            
            const size = Math.random() * 5 + 2;
            const left = Math.random() * 100;
            const duration = Math.random() * 10 + 10;
            const delay = Math.random() * 5;
            const colors = [
                'var(--primary-start)',
                'var(--primary-mid)',
                'var(--primary-end)',
                'var(--secondary-start)',
                'var(--secondary-end)'
            ];
            const color = colors[Math.floor(Math.random() * colors.length)];
            
            particle.style.cssText = `
                width: ${size}px;
                height: ${size}px;
                left: ${left}%;
                background: ${color};
                animation-duration: ${duration}s;
                animation-delay: ${delay}s;
            `;
            
            container.appendChild(particle);
        }
    }

    // Переключение видимости пароля
    const passwordToggle = document.getElementById('password-toggle');
    const passwordField = document.getElementById('password-field');

    if (passwordToggle && passwordField) {
        passwordToggle.addEventListener('click', function() {
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            
            const icon = this.querySelector('i');
            if (type === 'text') {
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
                this.style.color = 'var(--primary-end)';
                this.style.background = 'rgba(236, 72, 153, 0.1)';
            } else {
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
                this.style.color = 'rgba(203, 213, 225, 0.5)';
                this.style.background = 'none';
            }
            
            // Анимация кнопки
            this.style.transform = 'translateY(-50%) scale(1.2) rotate(15deg)';
            setTimeout(() => {
                this.style.transform = 'translateY(-50%) scale(1.1)';
            }, 200);
        });
    }

    // Анимация при отправке формы
    const loginForm = document.getElementById('login-form');
    if (loginForm) {
        loginForm.addEventListener('submit', function(e) {
            const button = document.getElementById('login-button');
            const originalContent = button.innerHTML;
            
            // Эффект загрузки
            button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Вход в систему...';
            button.disabled = true;
            button.style.animation = 'none';
            button.style.background = 'linear-gradient(135deg, #3b82f6, #1d4ed8)';
            
            // Создаем эффект прогресса
            const progressBar = document.createElement('div');
            progressBar.style.cssText = `
                position: absolute;
                bottom: 0;
                left: 0;
                height: 3px;
                background: linear-gradient(90deg, var(--primary-start), var(--primary-end));
                width: 0%;
                border-radius: 16px;
                transition: width 3s cubic-bezier(0.4, 0, 0.2, 1);
            `;
            button.appendChild(progressBar);
            
            // Анимация прогресса
            setTimeout(() => {
                progressBar.style.width = '100%';
            }, 100);
            
            // Имитация запроса
            setTimeout(() => {
                progressBar.remove();
                button.innerHTML = originalContent;
                button.disabled = false;
                button.style.animation = 'gradientFlow 3s ease infinite';
                button.style.background = 'linear-gradient(135deg, var(--primary-start) 0%, var(--primary-mid) 50%, var(--primary-end) 100%)';
                button.style.backgroundSize = '200% 200%';
                
                // Эффект успеха
                button.style.boxShadow = '0 0 30px rgba(34, 197, 94, 0.4)';
                setTimeout(() => {
                    button.style.boxShadow = '0 10px 30px rgba(99, 102, 241, 0.4), 0 0 30px rgba(99, 102, 241, 0.2)';
                }, 1000);
            }, 3000);
        });
    }

    // Анимация полей при загрузке
    document.addEventListener('DOMContentLoaded', function() {
        createParticles();
        
        const formGroups = document.querySelectorAll('.form-group');
        formGroups.forEach((group, index) => {
            group.style.opacity = '0';
            group.style.transform = 'translateY(30px)';
            
            setTimeout(() => {
                group.style.transition = 'all 0.6s cubic-bezier(0.34, 1.56, 0.64, 1)';
                group.style.opacity = '1';
                group.style.transform = 'translateY(0)';
            }, index * 100 + 300);
        });
        
        // Анимация логотипа
        const logo = document.querySelector('.logo-container');
        logo.style.animation = 'logoRotate 8s linear infinite, logoFloat 3s ease-in-out infinite';
        
        // Анимация заголовка
        const title = document.querySelector('h1');
        title.style.opacity = '0';
        title.style.transform = 'translateY(-20px)';
        
        setTimeout(() => {
            title.style.transition = 'all 0.8s cubic-bezier(0.34, 1.56, 0.64, 1)';
            title.style.opacity = '1';
            title.style.transform = 'translateY(0)';
        }, 500);
        
        // Эффект при наведении на карточку
        const loginCard = document.querySelector('.login-card');
        loginCard.addEventListener('mouseenter', () => {
            loginCard.style.transform = 'translateY(-8px) rotateX(2deg) rotateY(2deg)';
        });
        
        loginCard.addEventListener('mouseleave', () => {
            loginCard.style.transform = 'translateY(-8px)';
            setTimeout(() => {
                loginCard.style.transform = 'translateY(0)';
            }, 300);
        });
    });

    // Валидация полей
    const emailField = document.getElementById('email-field');
    const passwordField = document.getElementById('password-field');

    function validateEmail(email) {
        const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return re.test(email);
    }

    if (emailField) {
        emailField.addEventListener('blur', function() {
            if (this.value && !validateEmail(this.value)) {
                this.classList.add('error');
                createErrorEffect(this, 'Введите корректный email');
            } else if (this.value) {
                this.classList.remove('error');
                createSuccessEffect(this);
            }
        });
    }

    if (passwordField) {
        passwordField.addEventListener('blur', function() {
            if (this.value && this.value.length < 6) {
                this.classList.add('error');
                createErrorEffect(this, 'Пароль должен быть не менее 6 символов');
            } else if (this.value) {
                this.classList.remove('error');
                createSuccessEffect(this);
            }
        });
    }

    function createErrorEffect(element, message) {
        const errorDiv = element.parentElement.querySelector('.error-message');
        if (!errorDiv) {
            const errorElement = document.createElement('div');
            errorElement.className = 'error-message';
            errorElement.innerHTML = `<i class="fas fa-exclamation-circle"></i> ${message}`;
            element.parentElement.appendChild(errorElement);
            
            setTimeout(() => {
                errorElement.style.opacity = '1';
                errorElement.style.transform = 'translateY(0)';
            }, 10);
        }
        
        // Анимация поля
        element.style.animation = 'shakeError 0.5s ease';
        element.style.borderColor = '#ef4444';
        element.style.boxShadow = '0 0 0 4px rgba(239, 68, 68, 0.1), 0 0 20px rgba(239, 68, 68, 0.3)';
        
        setTimeout(() => {
            element.style.animation = '';
        }, 500);
    }

    function createSuccessEffect(element) {
        // Удаляем сообщение об ошибке
        const errorDiv = element.parentElement.querySelector('.error-message');
        if (errorDiv) {
            errorDiv.style.opacity = '0';
            errorDiv.style.transform = 'translateY(-10px)';
            setTimeout(() => {
                errorDiv.remove();
            }, 300);
        }
        
        // Анимация успеха
        element.style.borderColor = 'var(--primary-start)';
        element.style.boxShadow = '0 0 0 4px rgba(99, 102, 241, 0.1), 0 0 20px rgba(99, 102, 241, 0.3)';
        
        setTimeout(() => {
            if (!element.classList.contains('error')) {
                element.style.boxShadow = '';
                element.style.borderColor = 'rgba(51, 65, 85, 0.3)';
            }
        }, 1500);
    }

    // Случайное изменение цвета градиента каждые 5 секунд
    setInterval(() => {
        const hue1 = Math.floor(Math.random() * 360);
        const hue2 = (hue1 + 60) % 360;
        const hue3 = (hue1 + 120) % 360;
        
        document.documentElement.style.setProperty('--primary-start', `hsl(${hue1}, 70%, 60%)`);
        document.documentElement.style.setProperty('--primary-mid', `hsl(${hue2}, 70%, 60%)`);
        document.documentElement.style.setProperty('--primary-end', `hsl(${hue3}, 70%, 60%)`);
        
        // Обновляем частицы
        createParticles();
    }, 5000);
</script>
</body>
</html>